# **September 11, 2001, Documentary Project (U.S. Library of Congress)**

[![Website screenshot][image1]](https://www.loc.gov/collections/september-11th-2001-documentary-project/about-this-collection/)


### **Reviewed by:** Cathy Melamed 

### **Review date:** February 21, 2025  

### **Site Link**: [https://www.loc.gov/collections/september-11th-2001-documentary-project/about-this-collection/](https://www.loc.gov/collections/september-11th-2001-documentary-project/about-this-collection/) 

### **Archive Link:** [https://archive.ph/Mre6b](https://archive.ph/Mre6b) 

### **Keywords:**  Media Studies, Preservation, Historic Artefacts, September 11 

### **Data Sources:**   
* Over 8100 manuscript materials   
* Audio/visual recordings of 800 interviews  
* Over 400 graphic and photographic works    
* 15 electronic media artifacts  
* 38 physical artifacts

### **Processes:**  
* All artefacts have been digitized 

### **Presentation:**  
The [September 11, 2001, Documentary Project](https://www.loc.gov/collections/september-11th-2001-documentary-project/about-this-collection/) is an online collection of written, graphic, audio and video artefacts created in the months that followed the September 11 terrorist attacks. The home page features a 10-pane carousel of photographs and audio highlights; a description of the collection; links to a page of [Related Resources](https://www.loc.gov/collections/september-11th-2001-documentary-project/about-this-collection/related-resources/) and pages on the [U.S. Library of Congress](http://loc.gov/) website; a search engine; and social media sharing buttons. Visitors have the option to listen to the page. 

### **Digital Tools Used:**
* PHP   
* CentOS   
* JavaScript   
* MediaElement.js   
* Apache HTTP Server   
* Sentry   
* Amazon Web Services   
* Read Speaker   
* HSTS   
* Adobe Experience Platform Launch   
* Cloudflare   
* Amazon SE 

### **Languages:**  
* English 

### **Review**   
The [September 11, 2001, Documentary Project](https://www.loc.gov/collections/september-11th-2001-documentary-project/about-this-collection/) presents a wide variety of digitized media and artwork from the U.S. Library of Congress (LOC) collection of artefacts related to the terrorist attacks of that day.  The Documentary Project site features 200 audio and video interviews, 45 graphic items and 21 written narratives.  The complete LOC collection was an initiative of its [American Folklife Center](https://www.loc.gov/research-centers/american-folklife-center/about-this-research-center/) which, in 1941, captured national sentiment after the Pearl Harbor attack [through images and interviews.](https://www.loc.gov/collections/interviews-following-the-attack-on-pearl-harbor/about-this-collection/)  Similarly, the Documentary Project’s goal is to present a diverse cross-section of perspectives from people affected by the September 11 attacks to serve as “a historical and cultural resource for future generations.” The contributions range from interviews with those who survived the World Trade Center and Pentagon attacks to the reactions of those around the U.S. and around the world who learned about the events through family or through the media. 

<br>
Some of the first images that appear on the Documentary Project’s home page are colorful children’s illustrations of unimaginably sad subjects: broken, tearful towers set against a brilliant blue sky, and a bright American flag on a homemade sympathy card. There are handwritten goodbye letters to a mother, and an image of a poem called “The Towers,” left at a memorial site. After the September 11 attacks, a tremendous outpouring of national grief was recorded on paper and in photographs: “Missing” flyers, swarms of handwritten sticky notes, publicly posted tributes, and more. Later, people shared their painful memories of the day on audio and video. These items, collected by the Library of Congress, have become some of the artefacts shared by the Documentary Project. 

<br>
As each artefact has its own history and contains its own message, each is best viewed individually. All have been meticulously catalogued with source and format information, physical and digital locations, and detailed descriptions. The audio and video artefacts are authentic and moving, featuring both adults and children, service people and civilians. 

<br>
The collection is professionally organized and easy to navigate. The extensive filter options will be useful for researchers and educators in locating specific types of artefacts without having to spend time looking through countless files.  A helpful addition to the audio and video items would be transcripts, which would allow visitors to quickly preview content to see if it fits their interests.   

### **How are the collaborative aspects reflected in the project, and are there elements that work particularly well?**   
The project is a collaborative effort by design, as all materials were solicited from or shared by the public.  The Library of Congress’s preservation and cataloguing systems help record and standardize material collected by the American Folklife Center.    

### **Do you see an opportunity for collaboration that would be helpful to the project?**  
Collaborating with educators to create pedagogical materials seems a natural partnership.

[image1]: <data:image/png;base64,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>